<!--Copyright 2023 The HuggingFace Team. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
the License. You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.

⚠️ Note that this file is in Markdown but contain specific syntax for our doc-builder (similar to MDX) that may not be
rendered properly in your Markdown viewer.

-->

# BOFT

[Orthogonal Butterfly (BOFT)](https://hf.co/papers/2311.06243) is a generic method designed for finetuning foundation
models. It improves the paramter efficiency of the finetuning paradigm -- Orthogonal Finetuning (OFT), by taking
inspiration from Cooley-Tukey fast Fourier transform, showing favorable results across finetuning different foundation
models, including large vision transformers, large language models and text-to-image diffusion models.

The abstract from the paper is:

*Large foundation models are becoming ubiquitous, but training them from scratch is prohibitively expensive. Thus,
efficiently adapting these powerful models to downstream tasks is increasingly important. In this paper, we study a
principled finetuning paradigm -- Orthogonal Finetuning (OFT) -- for downstream task adaptation. Despite demonstrating
good generalizability, OFT still uses a fairly large number of trainable parameters due to the high dimensionality of
orthogonal matrices. To address this, we start by examining OFT from an information transmission perspective, and then
identify a few key desiderata that enable better parameter-efficiency. Inspired by how the Cooley-Tukey fast Fourier
transform algorithm enables efficient information transmission, we propose an efficient orthogonal parameterization
using butterfly structures. We apply this parameterization to OFT, creating a novel parameter-efficient finetuning
method, called Orthogonal Butterfly (BOFT). By subsuming OFT as a special case, BOFT introduces a generalized orthogonal
finetuning framework. Finally, we conduct an extensive empirical study of adapting large vision transformers, large
language models, and text-to-image diffusion models to various downstream tasks in vision and language*.

## BOFTConfig

[[autodoc]] tuners.boft.config.BOFTConfig

## BOFTModel

[[autodoc]] tuners.boft.model.BOFTModel
